/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class CemeteryRecruitmentEffect
extends OneShotEffect {
    CemeteryRecruitmentEffect() {
        super(Outcome.Benefit);
        this.staticText = "Return target creature card from your graveyard to your hand. If it's a Zombie card, draw a card";
    }

    private CemeteryRecruitmentEffect(CemeteryRecruitmentEffect effect) {
        super((OneShotEffect)effect);
    }

    public CemeteryRecruitmentEffect copy() {
        return new CemeteryRecruitmentEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
            if (card != null && controller.moveCards(card, Zone.HAND, source, game) && card.hasSubtype(SubType.ZOMBIE, game)) {
                controller.drawCards(1, source, game);
            }
            return true;
        }
        return false;
    }
}

