/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.util.ManaUtil;

class CephalidShrineEffect
extends OneShotEffect {
    CephalidShrineEffect() {
        super(Outcome.Detriment);
        this.staticText = "Whenever a player casts a spell, counter that spell unless that player pays {X}, where X is the number of cards in all graveyards with the same name as the spell";
    }

    private CephalidShrineEffect(CephalidShrineEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller;
        Spell spell;
        int count = 0;
        MageObject mageObject = game.getObject(source);
        if (mageObject != null && (spell = (Spell)game.getState().getValue("cephalidShrine" + mageObject)) != null && (controller = game.getPlayer(spell.getControllerId())) != null) {
            String name = spell.getName();
            FilterCard filterCardName = new FilterCard();
            filterCardName.add((Predicate)new NamePredicate(name));
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player = game.getPlayer(playerId);
                if (player == null) continue;
                count += player.getGraveyard().count(filterCardName, game);
            }
            ManaCost cost = ManaUtil.createManaCost((int)count, (boolean)true);
            if (game.getStack().contains((Object)spell) && cost.canPay(source, source, controller.getId(), game) && controller.chooseUse(this.outcome, "Pay " + cost.getText() + " to prevent countering " + spell.getName() + "?", source, game) && cost.pay(source, game, source, controller.getId(), false) && cost.isPaid()) {
                return false;
            }
            game.getStack().counter(spell.getId(), source, game);
            game.informPlayers(spell.getName() + " has been countered due to " + controller.getName() + " not paying " + cost.getText());
            return true;
        }
        return false;
    }

    public CephalidShrineEffect copy() {
        return new CephalidShrineEffect(this);
    }
}

