/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.common.DiscardCardCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.players.Player;

class ChainOfPlasmaEffect
extends OneShotEffect {
    ChainOfPlasmaEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals 3 damage to any target. Then that player or that permanent's controller may discard a card. If the player does, they may copy this spell and may choose a new target for that copy.";
    }

    private ChainOfPlasmaEffect(ChainOfPlasmaEffect effect) {
        super((OneShotEffect)effect);
    }

    public ChainOfPlasmaEffect copy() {
        return new ChainOfPlasmaEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            UUID targetId = source.getFirstTarget();
            Player affectedPlayer = null;
            Player player = game.getPlayer(targetId);
            if (player != null) {
                player.damage(3, source.getSourceId(), source, game);
                affectedPlayer = player;
            } else {
                Permanent permanent = game.getPermanent(targetId);
                if (permanent != null) {
                    permanent.damage(3, source.getSourceId(), source, game, false, true);
                    affectedPlayer = game.getPlayer(permanent.getControllerId());
                }
            }
            if (affectedPlayer != null) {
                Spell spell;
                DiscardCardCost cost;
                if (affectedPlayer.chooseUse(Outcome.Copy, "Discard a card to copy the spell?", source, game) && (cost = new DiscardCardCost()).pay(source, game, source, affectedPlayer.getId(), false, null) && (spell = game.getStack().getSpell(source.getSourceId())) != null) {
                    spell.createCopyOnStack(game, source, affectedPlayer.getId(), true);
                }
                return true;
            }
        }
        return false;
    }
}

