/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.cards.c.ChainerNightmareAdeptWatcher;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;

class ChainerNightmareAdeptContinuousEffect
extends AsThoughEffectImpl {
    ChainerNightmareAdeptContinuousEffect() {
        super(AsThoughEffectType.CAST_FROM_NOT_OWN_HAND_ZONE, Duration.EndOfTurn, Outcome.Benefit);
        this.staticText = "you may cast a creature spell from your graveyard this turn";
    }

    private ChainerNightmareAdeptContinuousEffect(ChainerNightmareAdeptContinuousEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public ChainerNightmareAdeptContinuousEffect copy() {
        return new ChainerNightmareAdeptContinuousEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        ChainerNightmareAdeptWatcher watcher = (ChainerNightmareAdeptWatcher)game.getState().getWatcher(ChainerNightmareAdeptWatcher.class);
        if (watcher != null) {
            watcher.addPlayable(source, game);
        }
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        throw new IllegalArgumentException("Wrong code usage: can't call applies method on empty affectedAbility");
    }

    public boolean applies(UUID objectId, Ability affectedAbility, Ability source, Game game, UUID playerId) {
        ChainerNightmareAdeptWatcher watcher = (ChainerNightmareAdeptWatcher)game.getState().getWatcher(ChainerNightmareAdeptWatcher.class);
        if (watcher == null || !watcher.checkPermission(playerId, source, game) || game.getState().getZone(objectId) != Zone.GRAVEYARD) {
            return false;
        }
        Card card = game.getCard(objectId);
        return card != null && affectedAbility instanceof SpellAbility && card.getOwnerId().equals(playerId) && ((SpellAbility)affectedAbility).getCharacteristics(game).isCreature();
    }
}

