/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CounterTargetEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ChaliceOfTheVoidTriggeredAbility
extends TriggeredAbilityImpl {
    public ChaliceOfTheVoidTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CounterTargetEffect());
    }

    private ChaliceOfTheVoidTriggeredAbility(ChaliceOfTheVoidTriggeredAbility abiltity) {
        super((TriggeredAbilityImpl)abiltity);
    }

    public ChaliceOfTheVoidTriggeredAbility copy() {
        return new ChaliceOfTheVoidTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent chalice = game.getPermanent(this.getSourceId());
        Spell spell = game.getStack().getSpell(event.getTargetId());
        if (spell != null && chalice != null && spell.getManaValue() == chalice.getCounters(game).getCount(CounterType.CHARGE)) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(event.getTargetId()));
            }
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a player casts a spell with mana value equal to the number of charge counters on {this}, counter that spell.";
    }
}

