/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetDiscard;

class ChandraAblazeDiscardCardEffect
extends OneShotEffect {
    public ChandraAblazeDiscardCardEffect() {
        super(Outcome.Discard);
        this.staticText = "Discard a card";
    }

    private ChandraAblazeDiscardCardEffect(ChandraAblazeDiscardCardEffect effect) {
        super((OneShotEffect)effect);
    }

    public ChandraAblazeDiscardCardEffect copy() {
        return new ChandraAblazeDiscardCardEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            TargetDiscard target = new TargetDiscard(player.getId());
            player.choose(Outcome.Discard, (Target)target, source, game);
            Card card = player.getHand().get(target.getFirstTarget(), game);
            if (card != null) {
                player.discard(card, false, source, game);
                ((Effect)source.getEffects().get(1)).setValue("discardedCard", (Object)card);
                game.getState().setValue(source.getSourceId().toString(), (Object)card);
                return true;
            }
        }
        return false;
    }
}

