/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.LoyaltyAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamagePlayersEffect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.MayCastTargetCardEffect;
import mage.abilities.effects.common.continuous.CastFromHandWithoutPayingManaCostEffect;
import mage.abilities.effects.common.discard.DiscardHandControllerEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.constants.TargetController;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.filter.common.FilterInstantOrSorceryCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

public final class ChandraFlamesCatalyst
extends CardImpl {
    private static final FilterCard filter = new FilterInstantOrSorceryCard("red instant or sorcery card from your graveyard");

    public ChandraFlamesCatalyst(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.PLANESWALKER}, "{4}{R}{R}");
        this.supertype.add(SuperType.LEGENDARY);
        this.subtype.add((Object)SubType.CHANDRA);
        this.setStartingLoyalty(5);
        this.addAbility((Ability)new LoyaltyAbility((Effect)new DamagePlayersEffect(3, TargetController.OPPONENT), 1));
        LoyaltyAbility ability = new LoyaltyAbility((Effect)new MayCastTargetCardEffect(true), -2);
        ability.addTarget((Target)new TargetCardInYourGraveyard(filter));
        this.addAbility((Ability)ability);
        DiscardHandControllerEffect discardHandEffect = new DiscardHandControllerEffect();
        DrawCardSourceControllerEffect drawEffect = new DrawCardSourceControllerEffect(7);
        drawEffect.setText(", then draw seven cards");
        CastFromHandWithoutPayingManaCostEffect castSpellsFromHandEffect = new CastFromHandWithoutPayingManaCostEffect((FilterCard)StaticFilters.FILTER_CARD_NON_LAND, true, Duration.EndOfTurn);
        castSpellsFromHandEffect.setText("Until end of turn, you may cast spells from your hand without paying their mana costs");
        LoyaltyAbility ultimateAbility = new LoyaltyAbility((Effect)discardHandEffect, -8);
        ultimateAbility.addEffect((Effect)drawEffect);
        ultimateAbility.addEffect((Effect)castSpellsFromHandEffect);
        this.addAbility((Ability)ultimateAbility);
    }

    private ChandraFlamesCatalyst(ChandraFlamesCatalyst card) {
        super((CardImpl)card);
    }

    public ChandraFlamesCatalyst copy() {
        return new ChandraFlamesCatalyst(this);
    }

    static {
        filter.add((Predicate)new ColorPredicate(ObjectColor.RED));
    }
}

