/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ChandraFlamesFuryEffect
extends OneShotEffect {
    ChandraFlamesFuryEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} deals 4 damage to target creature and 2 damage to that creature's controller.";
    }

    private ChandraFlamesFuryEffect(ChandraFlamesFuryEffect effect) {
        super((OneShotEffect)effect);
    }

    public ChandraFlamesFuryEffect copy() {
        return new ChandraFlamesFuryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        Player player = game.getPlayer(permanent.getControllerId());
        if (player == null) {
            return false;
        }
        permanent.damage(4, source.getSourceId(), source, game);
        player.damage(2, source.getSourceId(), source, game);
        return true;
    }
}

