/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.util.CardUtil;

class ChandraLegacyOfFireExileEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledPermanent();

    ChandraLegacyOfFireExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "remove a loyalty counter from each of any number of permanents you control. Exile that many cards from the top of your library. You may play them this turn";
    }

    private ChandraLegacyOfFireExileEffect(ChandraLegacyOfFireExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public ChandraLegacyOfFireExileEffect copy() {
        return new ChandraLegacyOfFireExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetPermanent target = new TargetPermanent(0, Integer.MAX_VALUE, filter, true);
        player.choose(this.outcome, (Target)target, source, game);
        int count = 0;
        for (UUID targetId : target.getTargets()) {
            Permanent permanent = game.getPermanent(targetId);
            if (permanent == null) {
                return false;
            }
            permanent.removeCounters(CounterType.LOYALTY.createInstance(), source, game);
            ++count;
        }
        if (count < 1) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, count));
        player.moveCards((Cards)cards, Zone.EXILED, source, game);
        for (Card card : cards.getCards(game)) {
            CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)false, (Duration)Duration.EndOfTurn, (boolean)false);
        }
        return true;
    }

    static {
        filter.add((Predicate)CounterType.LOYALTY.getPredicate());
    }
}

