/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.ApprovingObject;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamagePlayersEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Library;
import mage.players.Player;

class ChandraTorchOfDefianceEffect
extends OneShotEffect {
    ChandraTorchOfDefianceEffect() {
        super(Outcome.Detriment);
        this.staticText = "Exile the top card of your library. You may cast that card. If you don't, {this} deals 2 damage to each opponent";
    }

    private ChandraTorchOfDefianceEffect(ChandraTorchOfDefianceEffect effect) {
        super((OneShotEffect)effect);
    }

    public ChandraTorchOfDefianceEffect copy() {
        return new ChandraTorchOfDefianceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller != null && sourceObject != null && controller.getLibrary().hasCards()) {
            Library library = controller.getLibrary();
            Card card = library.getFromTop(game);
            if (card != null) {
                boolean cardWasCast = false;
                controller.moveCardsToExile(card, source, game, true, source.getSourceId(), sourceObject.getIdName());
                if (!(card.getManaCost().isEmpty() && card.isLand(game) || !controller.chooseUse(Outcome.Benefit, "Cast " + card.getName() + "? (You still pay the costs)", source, game) || game.getState().getZone(card.getId()) != Zone.EXILED)) {
                    game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), (Object)Boolean.TRUE);
                    cardWasCast = controller.cast(controller.chooseAbilityForCast(card, game, false), game, false, new ApprovingObject(source, game));
                    game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), null);
                }
                if (!cardWasCast) {
                    new DamagePlayersEffect(Outcome.Damage, (DynamicValue)StaticValue.get((int)2), TargetController.OPPONENT).apply(game, source);
                }
            }
            return true;
        }
        return false;
    }
}

