/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ChandrasDefeatEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent();

    public ChandrasDefeatEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals 5 damage to target red creature or red planeswalker. If it was a Chandra planeswalker, you may discard a card. If you do, draw a card.";
    }

    private ChandrasDefeatEffect(ChandrasDefeatEffect effect) {
        super((OneShotEffect)effect);
    }

    public ChandrasDefeatEffect copy() {
        return new ChandrasDefeatEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        Player controller = game.getPlayer(source.getControllerId());
        if (permanent != null) {
            permanent.damage(5, source.getSourceId(), source, game, false, true);
            if (filter.match((Object)permanent, game) && controller != null && controller.chooseUse(this.outcome, "Discard a card and draw a card?", source, game)) {
                controller.discard(1, false, false, source, game);
                controller.drawCards(1, source, game);
            }
            return true;
        }
        return false;
    }

    static {
        filter.add((Predicate)CardType.PLANESWALKER.getPredicate());
        filter.add((Predicate)SubType.CHANDRA.getPredicate());
    }
}

