/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class ChandrasIncineratorWatcher
extends Watcher {
    private final Map<UUID, Integer> damageMap = new HashMap<UUID, Integer>();

    ChandrasIncineratorWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.DAMAGED_PLAYER || ((DamagedPlayerEvent)event).isCombatDamage()) {
            return;
        }
        for (UUID playerId : game.getOpponents(event.getTargetId())) {
            this.damageMap.compute(playerId, (u, i) -> i == null ? event.getAmount() : Integer.sum(i, event.getAmount()));
        }
    }

    public void reset() {
        this.damageMap.clear();
        super.reset();
    }

    int getDamage(UUID playerId) {
        return this.damageMap.getOrDefault(playerId, 0);
    }
}

