/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPlaneswalkerPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ChandrasTriumphEffect
extends OneShotEffect {
    private static final FilterControlledPlaneswalkerPermanent filter = new FilterControlledPlaneswalkerPermanent(SubType.CHANDRA);

    ChandrasTriumphEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} deals 3 damage to target creature or planeswalker an opponent controls. {this} deals 5 damage to that permanent instead if you control a Chandra planeswalker.";
    }

    private ChandrasTriumphEffect(ChandrasTriumphEffect effect) {
        super((OneShotEffect)effect);
    }

    public ChandrasTriumphEffect copy() {
        return new ChandrasTriumphEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        int damage = 3;
        if (!game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), source, game).isEmpty()) {
            damage = 5;
        }
        return permanent.damage(damage, source.getSourceId(), source, game) > 0;
    }
}

