/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateDelayedTriggeredAbilityEffect;
import mage.abilities.effects.common.continuous.BoostAllEffect;
import mage.cards.c.ChaosMoonEvenReplacementEffect;
import mage.cards.c.ChaosMoonOddTriggeredAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.players.Player;

class ChaosMoonEffect
extends OneShotEffect {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("red creatures");

    ChaosMoonEffect() {
        super(Outcome.Neutral);
        this.staticText = "count the number of permanents. If the number is odd, until end of turn, red creatures get +1/+1 and whenever a player taps a Mountain for mana, that player adds an additional {R}. If the number is even, until end of turn, red creatures get -1/-1 and if a player taps a Mountain for mana, that Mountain produces colorless mana instead of any other type";
    }

    private ChaosMoonEffect(ChaosMoonEffect effect) {
        super((OneShotEffect)effect);
    }

    public ChaosMoonEffect copy() {
        return new ChaosMoonEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int permanentsInPlay = game.getBattlefield().count(StaticFilters.FILTER_PERMANENT, source.getControllerId(), source, game);
        if (permanentsInPlay % 2 == 1) {
            game.addEffect((ContinuousEffect)new BoostAllEffect(1, 1, Duration.EndOfTurn, filter, false), source);
            new CreateDelayedTriggeredAbilityEffect((DelayedTriggeredAbility)new ChaosMoonOddTriggeredAbility()).apply(game, source);
        } else {
            game.addEffect((ContinuousEffect)new BoostAllEffect(-1, -1, Duration.EndOfTurn, filter, false), source);
            game.addEffect((ContinuousEffect)new ChaosMoonEvenReplacementEffect(), source);
        }
        return true;
    }

    static {
        filter.add((Predicate)new ColorPredicate(ObjectColor.RED));
    }
}

