/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ManaEvent;
import mage.game.events.TappedForManaEvent;
import mage.game.permanent.Permanent;

class ChaosMoonEvenReplacementEffect
extends ReplacementEffectImpl {
    ChaosMoonEvenReplacementEffect() {
        super(Duration.EndOfTurn, Outcome.Neutral);
        this.staticText = "Until end of turn, if a Mountain is tapped for mana, it produces colorless mana instead of any other type.";
    }

    private ChaosMoonEvenReplacementEffect(ChaosMoonEvenReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public ChaosMoonEvenReplacementEffect copy() {
        return new ChaosMoonEvenReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        ManaEvent manaEvent = (ManaEvent)event;
        Mana mana = manaEvent.getMana();
        mana.setToMana(Mana.ColorlessMana((int)mana.count()));
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TAPPED_FOR_MANA;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent land = ((TappedForManaEvent)event).getPermanent();
        return land != null && land.hasSubtype(SubType.MOUNTAIN, game);
    }
}

