/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.Mana;
import mage.abilities.effects.Effect;
import mage.abilities.effects.mana.AddManaToManaPoolTargetControllerEffect;
import mage.abilities.mana.DelayedTriggeredManaAbility;
import mage.constants.ColoredManaSymbol;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.TappedForManaEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ChaosMoonOddTriggeredAbility
extends DelayedTriggeredManaAbility {
    ChaosMoonOddTriggeredAbility() {
        super((Effect)new AddManaToManaPoolTargetControllerEffect(new Mana(ColoredManaSymbol.R), "their"), Duration.EndOfTurn, Boolean.valueOf(false));
        this.usesStack = false;
    }

    private ChaosMoonOddTriggeredAbility(ChaosMoonOddTriggeredAbility ability) {
        super((DelayedTriggeredManaAbility)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TAPPED_FOR_MANA;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent land = ((TappedForManaEvent)event).getPermanent();
        if (land == null || !land.hasSubtype(SubType.MOUNTAIN, game)) {
            return false;
        }
        this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(land.getControllerId()));
        return true;
    }

    public ChaosMoonOddTriggeredAbility copy() {
        return new ChaosMoonOddTriggeredAbility(this);
    }

    public String getRule() {
        return "Until end of turn, whenever a player taps a Mountain for mana, that player adds {R}";
    }
}

