/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.HashSet;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;

class ChaoticTransformationEffect
extends OneShotEffect {
    ChaoticTransformationEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "Exile up to one target artifact, up to one target creature, up to one target enchantment, up to one target planeswalker, and/or up to one target land. For each permanent exiled this way, its controller reveals cards from the top of their library until they reveal a card that shares a card type with it, puts that card onto the battlefield, then shuffles.";
    }

    private ChaoticTransformationEffect(ChaoticTransformationEffect effect) {
        super((OneShotEffect)effect);
    }

    public ChaoticTransformationEffect copy() {
        return new ChaoticTransformationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player sourceController = game.getPlayer(source.getControllerId());
        if (sourceController == null) {
            return false;
        }
        for (Target target : source.getTargets()) {
            Permanent permanent = game.getPermanent(target.getFirstTarget());
            if (permanent == null) continue;
            Player permanentController = game.getPlayer(permanent.getControllerId());
            HashSet<CardType> types = new HashSet<CardType>(permanent.getCardType(game));
            if (!sourceController.moveCards((Card)permanent, Zone.EXILED, source, game) || permanentController == null) continue;
            CardsImpl revealedCards = new CardsImpl();
            Card toBattlefield = null;
            for (Card card : permanentController.getLibrary().getCards(game)) {
                revealedCards.add(card);
                if (!this.sharesType(card, types, game)) continue;
                toBattlefield = card;
                break;
            }
            if (!revealedCards.isEmpty()) {
                permanentController.revealCards(source, (Cards)revealedCards, game);
            }
            if (toBattlefield != null) {
                permanentController.moveCards(toBattlefield, Zone.BATTLEFIELD, source, game);
            }
            permanentController.shuffleLibrary(source, game);
        }
        return true;
    }

    private boolean sharesType(Card card, HashSet<CardType> types, Game game) {
        for (CardType type : card.getCardType(game)) {
            if (!types.contains(type)) continue;
            return true;
        }
        return false;
    }
}

