/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.costs.common.RevealTargetFromHandCost;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ChargeOfTheForeverBeastEffect
extends OneShotEffect {
    ChargeOfTheForeverBeastEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} deals damage to target creature or planeswalker equal to the revealed card's power";
    }

    private ChargeOfTheForeverBeastEffect(ChargeOfTheForeverBeastEffect effect) {
        super((OneShotEffect)effect);
    }

    public ChargeOfTheForeverBeastEffect copy() {
        return new ChargeOfTheForeverBeastEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        RevealTargetFromHandCost cost = (RevealTargetFromHandCost)source.getCosts().get(0);
        if (permanent == null || cost == null) {
            return false;
        }
        Card card = (Card)cost.getRevealedCards().get(0);
        if (card == null) {
            return false;
        }
        return permanent.damage(card.getPower().getValue(), source.getSourceId(), source, game) > 0;
    }
}

