/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.CountersSourceCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ChargingCinderhornDamageTargetEffect
extends OneShotEffect {
    ChargingCinderhornDamageTargetEffect() {
        super(Outcome.Damage);
    }

    private ChargingCinderhornDamageTargetEffect(ChargingCinderhornDamageTargetEffect copy) {
        super((OneShotEffect)copy);
    }

    public boolean apply(Game game, Ability source) {
        Permanent chargingCinderhoof = game.getPermanent(source.getSourceId());
        if (chargingCinderhoof != null) {
            chargingCinderhoof.addCounters(CounterType.FURY.createInstance(), source.getControllerId(), source, game);
        } else {
            chargingCinderhoof = game.getPermanentOrLKIBattlefield(source.getSourceId());
        }
        if (chargingCinderhoof == null) {
            return false;
        }
        CountersSourceCount amount = new CountersSourceCount(CounterType.FURY);
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player != null) {
            player.damage(amount.calculate(game, source, (Effect)this), source.getSourceId(), source, game);
            return true;
        }
        return false;
    }

    public ChargingCinderhornDamageTargetEffect copy() {
        return new ChargingCinderhornDamageTargetEffect(this);
    }
}

