/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.keyword.FlashAbility;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class CheckForTrapsEffect
extends OneShotEffect {
    CheckForTrapsEffect() {
        super(Outcome.Discard);
        this.staticText = "Target opponent reveals their hand. You choose a nonland card from it. Exile that card. If an instant card or a card with flash is exiled this way, they lose 1 life. Otherwise, you lose 1 life";
    }

    private CheckForTrapsEffect(CheckForTrapsEffect effect) {
        super((OneShotEffect)effect);
    }

    public CheckForTrapsEffect copy() {
        return new CheckForTrapsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller == null || opponent == null) {
            return false;
        }
        opponent.revealCards(source, opponent.getHand(), game);
        TargetCard target = new TargetCard(Zone.HAND, (FilterCard)StaticFilters.FILTER_CARD_NON_LAND);
        target.withNotTarget(true);
        boolean opponentLoseLife = false;
        if (controller.choose(this.outcome, opponent.getHand(), target, source, game) && (card = game.getCard(target.getFirstTarget())) != null) {
            controller.moveCards(card, Zone.EXILED, source, game);
            if (card.isInstant(game) || card.hasAbility((Ability)FlashAbility.getInstance(), game)) {
                opponentLoseLife = true;
            }
        }
        if (opponentLoseLife) {
            opponent.loseLife(1, game, source, false);
        } else {
            controller.loseLife(1, game, source, false);
        }
        return true;
    }
}

