/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class CheeringCrowdEffect
extends OneShotEffect {
    public CheeringCrowdEffect() {
        super(Outcome.PutManaInPool);
        this.staticText = "they add {C} for each counter on it";
    }

    protected CheeringCrowdEffect(CheeringCrowdEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        Permanent permanent = source.getSourcePermanentOrLKI(game);
        if (player == null || permanent == null) {
            return false;
        }
        int counterCounter = permanent.getCounters(game).getCount(CounterType.P1P1);
        player.getManaPool().addMana(Mana.ColorlessMana((int)counterCounter), game, source);
        return true;
    }

    public CheeringCrowdEffect copy() {
        return new CheeringCrowdEffect(this);
    }
}

