/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ChooseACardNameEffect;
import mage.abilities.effects.common.cost.SpellsCostReductionAllEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;

class CheeringFanaticEffect
extends OneShotEffect {
    CheeringFanaticEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose a card name. Spells with the chosen name cost {1} less to cast this turn";
    }

    private CheeringFanaticEffect(CheeringFanaticEffect effect) {
        super((OneShotEffect)effect);
    }

    public CheeringFanaticEffect copy() {
        return new CheeringFanaticEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        new ChooseACardNameEffect(ChooseACardNameEffect.TypeOfName.ALL).apply(game, source);
        String cardName = (String)game.getState().getValue(source.getSourceId().toString() + "NAMED_CARD");
        if (cardName == null) {
            return false;
        }
        FilterCard filter = new FilterCard();
        filter.add((Predicate)new NamePredicate(cardName));
        SpellsCostReductionAllEffect effect = new SpellsCostReductionAllEffect(filter, 1);
        effect.setDuration(Duration.EndOfTurn);
        game.addEffect((ContinuousEffect)effect, source);
        return true;
    }
}

