/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.EntersBattlefieldTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.FightTargetSourceEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class CherishedHatchlingTriggeredAbility
extends DelayedTriggeredAbility {
    public CherishedHatchlingTriggeredAbility() {
        super(CherishedHatchlingTriggeredAbility.getEffectToAdd(), Duration.EndOfTurn, false);
        this.setTriggerPhrase("whenever you cast a Dinosaur spell this turn, ");
    }

    private static Effect getEffectToAdd() {
        EntersBattlefieldTriggeredAbility abilityToAdd = new EntersBattlefieldTriggeredAbility((Effect)new FightTargetSourceEffect().setText("you may have it fight another target creature"), true);
        abilityToAdd.addTarget((Target)new TargetPermanent((FilterPermanent)StaticFilters.FILTER_ANOTHER_TARGET_CREATURE));
        return new GainAbilityTargetEffect((Ability)abilityToAdd, Duration.EndOfTurn, "it gains \"When this creature enters, you may have it fight another target creature.\"", true);
    }

    private CherishedHatchlingTriggeredAbility(CherishedHatchlingTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public CherishedHatchlingTriggeredAbility copy() {
        return new CherishedHatchlingTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Spell spell;
        if (event.getPlayerId().equals(this.getControllerId()) && (spell = game.getStack().getSpell(event.getTargetId())) != null && spell.isCreature(game) && spell.hasSubtype(SubType.DINOSAUR, game)) {
            this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(spell.getSourceId()));
            return true;
        }
        return false;
    }
}

