/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.TriggeredAbility;
import mage.abilities.common.DiesCreatureTriggeredAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.PermanentsOnTheBattlefieldCondition;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.abilities.keyword.DeathtouchAbility;
import mage.abilities.triggers.BeginningOfUpkeepTriggeredAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.constants.TargetController;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreatureOrPlaneswalkerPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.target.Target;
import mage.target.TargetPermanent;

public final class ChevillBaneOfMonsters
extends CardImpl {
    private static final FilterPermanent filter = new FilterPermanent("your opponents control no permanents with bounty counters on them");
    private static final FilterPermanent filter2 = new FilterCreatureOrPlaneswalkerPermanent("creature or planeswalker an opponent controls");
    private static final FilterPermanent filter3 = new FilterPermanent("a permanent an opponent controls with a bounty counter on it");
    private static final Condition condition;

    public ChevillBaneOfMonsters(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{B}{G}");
        this.supertype.add(SuperType.LEGENDARY);
        this.subtype.add((Object)SubType.HUMAN);
        this.subtype.add((Object)SubType.ROGUE);
        this.power = new MageInt(1);
        this.toughness = new MageInt(3);
        this.addAbility((Ability)DeathtouchAbility.getInstance());
        TriggeredAbility ability = new BeginningOfUpkeepTriggeredAbility((Effect)new AddCountersTargetEffect(CounterType.BOUNTY.createInstance())).withInterveningIf(condition);
        ability.addTarget((Target)new TargetPermanent(filter2));
        this.addAbility((Ability)ability);
        ability = new DiesCreatureTriggeredAbility((Effect)new GainLifeEffect(3), false, filter3);
        ability.addEffect((Effect)new DrawCardSourceControllerEffect(1).concatBy("and"));
        this.addAbility((Ability)ability);
    }

    private ChevillBaneOfMonsters(ChevillBaneOfMonsters card) {
        super((CardImpl)card);
    }

    public ChevillBaneOfMonsters copy() {
        return new ChevillBaneOfMonsters(this);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)TargetController.OPPONENT.getControllerPredicate());
        filter.add((Predicate)CounterType.BOUNTY.getPredicate());
        filter2.add((ObjectSourcePlayerPredicate)TargetController.OPPONENT.getControllerPredicate());
        filter3.add((ObjectSourcePlayerPredicate)TargetController.OPPONENT.getControllerPredicate());
        filter3.add((Predicate)CounterType.BOUNTY.getPredicate());
        condition = new PermanentsOnTheBattlefieldCondition(filter, ComparisonType.EQUAL_TO, 0, false);
    }
}

