/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.cards.c.ChissGoriaForgeTyrantWatcher;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.util.CardUtil;

class ChissGoriaForgeTyrantCanPlayEffect
extends AsThoughEffectImpl {
    private final Set<MageObjectReference> morSet = new HashSet<MageObjectReference>();

    ChissGoriaForgeTyrantCanPlayEffect(Set<MageObjectReference> morSet) {
        super(AsThoughEffectType.CAST_FROM_NOT_OWN_HAND_ZONE, Duration.EndOfTurn, Outcome.Benefit);
        this.morSet.addAll(morSet);
    }

    private ChissGoriaForgeTyrantCanPlayEffect(ChissGoriaForgeTyrantCanPlayEffect effect) {
        super((AsThoughEffectImpl)effect);
        this.morSet.addAll(effect.morSet);
    }

    public ChissGoriaForgeTyrantCanPlayEffect copy() {
        return new ChissGoriaForgeTyrantCanPlayEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public boolean applies(UUID sourceId, Ability source, UUID affectedControllerId, Game game) {
        if (!source.isControlledBy(affectedControllerId)) {
            return false;
        }
        UUID objectIdToCast = CardUtil.getMainCardId((Game)game, (UUID)sourceId);
        Card card = game.getCard(objectIdToCast);
        return card != null && card.isArtifact(game) && this.morSet.stream().anyMatch(mor -> mor.refersTo(objectIdToCast, game)) && ChissGoriaForgeTyrantWatcher.checkRef(source, this.morSet, game);
    }
}

