/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;

class ChissGoriaForgeTyrantWatcher
extends Watcher {
    private final Map<MageObjectReference, Set<MageObjectReference>> morMap = new HashMap<MageObjectReference, Set<MageObjectReference>>();
    private static final Set<MageObjectReference> emptySet = new HashSet<MageObjectReference>();

    ChissGoriaForgeTyrantWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.SPELL_CAST || event.getApprovingObject() == null) {
            return;
        }
        MageObjectReference mor = event.getApprovingObject().getApprovingMageObjectReference();
        Spell spell = game.getSpell(event.getTargetId());
        if (mor == null || spell == null) {
            return;
        }
        this.morMap.computeIfAbsent(mor, x -> new HashSet()).add(new MageObjectReference((MageObject)spell.getMainCard(), game, -1));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean checkRef(Ability source, Set<MageObjectReference> morSet, Game game) {
        ChissGoriaForgeTyrantWatcher watcher = (ChissGoriaForgeTyrantWatcher)game.getState().getWatcher(ChissGoriaForgeTyrantWatcher.class);
        if (watcher == null) return false;
        if (!watcher.morMap.getOrDefault(new MageObjectReference(source.getSourceObject(game), game), emptySet).stream().noneMatch(morSet::contains)) return false;
        return true;
    }
}

