/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class ChoiceOfDamnationsEffect
extends OneShotEffect {
    ChoiceOfDamnationsEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target opponent chooses a number. You may have that player lose that much life. If you don't, that player sacrifices all but that many permanents";
    }

    private ChoiceOfDamnationsEffect(ChoiceOfDamnationsEffect effect) {
        super((OneShotEffect)effect);
    }

    public ChoiceOfDamnationsEffect copy() {
        return new ChoiceOfDamnationsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (targetPlayer != null) {
            int amount;
            int numberPermanents = game.getBattlefield().countAll(new FilterPermanent(), targetPlayer.getId(), game);
            if (targetPlayer.isComputer()) {
                int safeLifeToLost = Math.max(0, targetPlayer.getLife() / 2);
                amount = Math.min(numberPermanents, safeLifeToLost);
            } else {
                amount = targetPlayer.getAmount(0, Integer.MAX_VALUE, "Chooses a number", source, game);
            }
            Player controller = game.getPlayer(source.getControllerId());
            if (controller != null) {
                boolean chooseLoseLife = targetPlayer.isComputer() ? numberPermanents == 0 || amount <= numberPermanents || targetPlayer.getLife() < amount : controller.chooseUse(this.outcome, "Shall " + targetPlayer.getLogName() + " lose " + amount + " life?", source, game);
                if (chooseLoseLife) {
                    targetPlayer.loseLife(amount, game, source, false);
                } else if (numberPermanents > amount) {
                    int numberToSacrifice;
                    TargetSacrifice target = new TargetSacrifice(numberToSacrifice, (numberToSacrifice = numberPermanents - amount) == 1 ? StaticFilters.FILTER_PERMANENT : StaticFilters.FILTER_PERMANENTS);
                    targetPlayer.choose(Outcome.Sacrifice, (Target)target, source, game);
                    for (UUID uuid : target.getTargets()) {
                        Permanent permanent = game.getPermanent(uuid);
                        if (permanent == null) continue;
                        permanent.sacrifice(source, game);
                    }
                }
                return true;
            }
        }
        return false;
    }
}

