/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.condition.common.KickedCondition;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;

class ChokingMiasmaEffect
extends OneShotEffect {
    ChokingMiasmaEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "If this spell was kicked, put a +1/+1 counter on a creature you control.";
    }

    private ChokingMiasmaEffect(ChokingMiasmaEffect effect) {
        super((OneShotEffect)effect);
    }

    public ChokingMiasmaEffect copy() {
        return new ChokingMiasmaEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        if (!KickedCondition.ONCE.apply(game, source)) {
            return false;
        }
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TargetControlledCreaturePermanent target = new TargetControlledCreaturePermanent();
        target.withNotTarget(true);
        if (!target.canChoose(controller.getId(), source, game)) {
            return false;
        }
        controller.chooseTarget(this.outcome, (Target)target, source, game);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        permanent.addCounters(CounterType.P1P1.createInstance(), source, game);
        if (!game.isSimulation()) {
            StringBuilder sb = new StringBuilder();
            MageObject sourceObject = game.getObject(source);
            if (sourceObject != null) {
                sb.append(sourceObject.getLogName());
                sb.append(": ");
            }
            sb.append(controller.getLogName());
            sb.append(" put a +1/+1 counter on ");
            sb.append(permanent.getLogName());
            game.informPlayers(sb.toString());
        }
        return true;
    }
}

