/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ChooseYourWeaponEffect
extends OneShotEffect {
    ChooseYourWeaponEffect() {
        super(Outcome.Benefit);
        this.staticText = "double target creature's power and toughness until end of turn";
    }

    private ChooseYourWeaponEffect(ChooseYourWeaponEffect effect) {
        super((OneShotEffect)effect);
    }

    public ChooseYourWeaponEffect copy() {
        return new ChooseYourWeaponEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        game.addEffect((ContinuousEffect)new BoostTargetEffect(permanent.getPower().getValue(), permanent.getToughness().getValue(), Duration.EndOfTurn), source);
        return true;
    }
}

