/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.HashMap;
import java.util.Map;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.util.ManaUtil;

class ChorusOfTheConclaveReplacementEffect
extends ReplacementEffectImpl {
    ChorusOfTheConclaveReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "As an additional cost to cast creature spells, you may pay any amount of mana";
    }

    private ChorusOfTheConclaveReplacementEffect(ChorusOfTheConclaveReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public ChorusOfTheConclaveReplacementEffect copy() {
        return new ChorusOfTheConclaveReplacementEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        MageObject spellObject;
        if (event.getPlayerId().equals(source.getControllerId()) && (spellObject = game.getObject(event.getSourceId())) != null) {
            return spellObject.isCreature(game);
        }
        return false;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        int xCost = 0;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && controller.chooseUse(Outcome.Benefit, "Pay the additonal cost to add +1/+1 counters to the creature you cast?", source, game)) {
            Object object = game.getState().getValue("spellX" + source.getSourceId());
            HashMap<String, Integer> spellX = object instanceof Map ? (HashMap<String, Integer>)object : new HashMap<String, Integer>();
            spellX.put(event.getSourceId().toString() + game.getState().getZoneChangeCounter(event.getSourceId()), xCost += ManaUtil.playerPaysXGenericMana((boolean)false, (String)"Chorus of the Conclave", (Player)controller, (Ability)source, (Game)game));
            game.getState().setValue("spellX" + source.getSourceId(), spellX);
        }
        return false;
    }
}

