/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;

class ChromeCourierEffect
extends OneShotEffect {
    ChromeCourierEffect() {
        super(Outcome.Benefit);
        this.staticText = "reveal the top two cards of your library. Put one of them into your hand and the other into your graveyard. If you put an artifact card into your hand this way, you gain 3 life";
    }

    private ChromeCourierEffect(ChromeCourierEffect effect) {
        super((OneShotEffect)effect);
    }

    public ChromeCourierEffect copy() {
        return new ChromeCourierEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 2));
        player.revealCards(source, (Cards)cards, game);
        switch (cards.size()) {
            case 0: {
                card = null;
                break;
            }
            case 1: {
                card = cards.getRandom(game);
                break;
            }
            default: {
                TargetCardInLibrary target = new TargetCardInLibrary();
                target.withChooseHint("to hand");
                player.choose(this.outcome, (Cards)cards, (TargetCard)target, source, game);
                card = cards.get(target.getFirstTarget(), game);
            }
        }
        player.moveCards(card, Zone.HAND, source, game);
        cards.remove(card);
        player.moveCards((Cards)cards, Zone.GRAVEYARD, source, game);
        if (card != null && card.isArtifact(game)) {
            player.gainLife(3, game, source);
        }
        return true;
    }
}

