/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class CircleOfTheMoonDruidBearEffect
extends ContinuousEffectImpl {
    CircleOfTheMoonDruidBearEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "during your turn, {this} is a Bear with base power and toughness 4/2";
    }

    private CircleOfTheMoonDruidBearEffect(CircleOfTheMoonDruidBearEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public CircleOfTheMoonDruidBearEffect copy() {
        return new CircleOfTheMoonDruidBearEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null || !game.isActivePlayer(source.getControllerId())) {
            return false;
        }
        switch (layer) {
            case TypeChangingEffects_4: {
                permanent.removeAllCreatureTypes(game);
                permanent.addSubType(game, new SubType[]{SubType.BEAR});
                return true;
            }
            case PTChangingEffects_7: {
                if (sublayer != SubLayer.SetPT_7b) break;
                permanent.getPower().setModifiedBaseValue(4);
                permanent.getToughness().setModifiedBaseValue(2);
                return true;
            }
        }
        return false;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.TypeChangingEffects_4 || layer == Layer.PTChangingEffects_7;
    }
}

