/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class CirclingVulturesDiscardEffect
extends OneShotEffect {
    public CirclingVulturesDiscardEffect() {
        super(Outcome.Neutral);
        this.staticText = "discard {this}";
    }

    private CirclingVulturesDiscardEffect(CirclingVulturesDiscardEffect effect) {
        super((OneShotEffect)effect);
    }

    public CirclingVulturesDiscardEffect copy() {
        return new CirclingVulturesDiscardEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Card card = player.getHand().get(source.getSourceId(), game);
        if (card == null) {
            return false;
        }
        return player.discard(card, false, source, game);
    }
}

