/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;
import mage.util.CardUtil;

class CitanulFluteSearchEffect
extends OneShotEffect {
    CitanulFluteSearchEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Search your library for a creature card with mana value X or less, reveal it, put it into your hand, then shuffle";
    }

    private CitanulFluteSearchEffect(CitanulFluteSearchEffect effect) {
        super((OneShotEffect)effect);
    }

    public CitanulFluteSearchEffect copy() {
        return new CitanulFluteSearchEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        FilterCreatureCard filter = new FilterCreatureCard("creature card with mana value X or less");
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0) + 1));
        TargetCardInLibrary target = new TargetCardInLibrary((FilterCard)filter);
        player.searchLibrary(target, source, game);
        Card card = player.getLibrary().getCard(target.getFirstTarget(), game);
        if (card != null) {
            player.revealCards(source, (Cards)new CardsImpl(card), game);
            player.moveCards(card, Zone.HAND, source, game);
        }
        player.shuffleLibrary(source, game);
        return true;
    }
}

