/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Collection;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInHand;

class CitystalkerConnoisseurEffect
extends OneShotEffect {
    CitystalkerConnoisseurEffect() {
        super(Outcome.Discard);
        this.staticText = "target opponent discards a card with the greatest mana value among cards in their hand";
    }

    private CitystalkerConnoisseurEffect(CitystalkerConnoisseurEffect effect) {
        super((OneShotEffect)effect);
    }

    public CitystalkerConnoisseurEffect copy() {
        return new CitystalkerConnoisseurEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getFirstTarget());
        if (player == null || player.getHand().isEmpty()) {
            return false;
        }
        if (player.getHand().size() == 1) {
            player.discard(player.getHand(), false, source, game);
            return true;
        }
        int maxValue = player.getHand().getCards(game).stream().mapToInt(MageObject::getManaValue).max().orElse(0);
        CardsImpl cards = new CardsImpl((Collection)player.getHand());
        cards.removeIf(uuid -> game.getCard(uuid).getManaValue() < maxValue);
        if (cards.size() == 1) {
            player.discard((Cards)cards, false, source, game);
            return true;
        }
        TargetCardInHand target = new TargetCardInHand();
        player.choose(this.outcome, (Cards)cards, (TargetCard)target, source, game);
        player.discard(cards.get(target.getFirstTarget(), game), false, source, game);
        return true;
    }
}

