/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledPermanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ClambassadorsEffect
extends OneShotEffect {
    private static final FilterControlledPermanent filter = new FilterControlledPermanent("artifact, creature, or land you control");

    public ClambassadorsEffect() {
        super(Outcome.Detriment);
        this.staticText = "choose an artifact, creature, or land you control. That player gains control of that permanent";
    }

    private ClambassadorsEffect(ClambassadorsEffect effect) {
        super((OneShotEffect)effect);
    }

    public ClambassadorsEffect copy() {
        return new ClambassadorsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            TargetControlledPermanent target = new TargetControlledPermanent(1, 1, filter, true);
            if (target.canChoose(controller.getId(), source, game)) {
                while (!target.isChosen(game) && target.canChoose(controller.getId(), source, game) && controller.canRespond()) {
                    controller.chooseTarget(this.outcome, (Target)target, source, game);
                }
            }
            Permanent permanent = game.getPermanent(target.getFirstTarget());
            Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
            if (permanent != null && opponent != null) {
                GainControlTargetEffect effect = new GainControlTargetEffect(Duration.Custom, true, opponent.getId());
                effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
                game.addEffect((ContinuousEffect)effect, source);
                game.informPlayers(opponent.getLogName() + " has gained control of " + permanent.getLogName());
                return true;
            }
        }
        return false;
    }

    static {
        filter.add(Predicates.or((Predicate[])new Predicate[]{CardType.ARTIFACT.getPredicate(), CardType.CREATURE.getPredicate(), CardType.LAND.getPredicate()}));
        filter.add(Predicates.or((Predicate[])new Predicate[]{CardType.ARTIFACT.getPredicate(), CardType.CREATURE.getPredicate(), CardType.LAND.getPredicate()}));
    }
}

