/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Mode;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.GetXValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.AbilityPredicate;
import mage.target.TargetPermanent;
import mage.target.common.TargetPlayerOrPlaneswalker;

public final class ClanDefiance
extends CardImpl {
    private static final FilterCreaturePermanent filterWithoutFlying = new FilterCreaturePermanent("creature without flying");

    public ClanDefiance(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.SORCERY}, "{X}{R}{G}");
        this.getSpellAbility().getModes().setMinModes(1);
        this.getSpellAbility().getModes().setMaxModes(3);
        this.getSpellAbility().addEffect((Effect)new DamageTargetEffect((DynamicValue)GetXValue.instance));
        this.getSpellAbility().addTarget(new TargetPermanent((FilterPermanent)StaticFilters.FILTER_CREATURE_FLYING).withChooseHint("deals X damage, with flying"));
        Mode mode1 = new Mode((Effect)new DamageTargetEffect((DynamicValue)GetXValue.instance));
        mode1.addTarget(new TargetPermanent((FilterPermanent)filterWithoutFlying).withChooseHint("deals X damage, without flying"));
        this.getSpellAbility().addMode(mode1);
        Mode mode2 = new Mode((Effect)new DamageTargetEffect((DynamicValue)GetXValue.instance));
        mode2.addTarget(new TargetPlayerOrPlaneswalker().withChooseHint("deals X damage"));
        this.getSpellAbility().addMode(mode2);
    }

    private ClanDefiance(ClanDefiance card) {
        super((CardImpl)card);
    }

    public ClanDefiance copy() {
        return new ClanDefiance(this);
    }

    static {
        filterWithoutFlying.add(Predicates.not((Predicate)new AbilityPredicate(FlyingAbility.class)));
    }
}

