/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.common.ZoneChangeTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityAllEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.target.Target;
import mage.target.TargetPermanent;

public final class ClashOfRealities
extends CardImpl {
    private static final FilterCreaturePermanent filterSpirit = new FilterCreaturePermanent("Spirit creature");
    private static final FilterCreaturePermanent filterNotSpirit = new FilterCreaturePermanent("non-Spirit creature");

    public ClashOfRealities(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{3}{R}");
        ClashOfRealitiesTriggeredAbility ability1 = new ClashOfRealitiesTriggeredAbility((Effect)new DamageTargetEffect(3), "When this permanent enters, ");
        ability1.addTarget((Target)new TargetPermanent((FilterPermanent)filterNotSpirit));
        this.addAbility((Ability)new SimpleStaticAbility((Effect)new GainAbilityAllEffect((Ability)ability1, Duration.WhileOnBattlefield, (FilterPermanent)filterSpirit, "All Spirits have \"When this permanent enters the battlefield, you may have it deal 3 damage to target non-Spirit creature.\"")));
        ClashOfRealitiesTriggeredAbility ability2 = new ClashOfRealitiesTriggeredAbility((Effect)new DamageTargetEffect(3), "When this creature enters, ");
        ability2.addTarget((Target)new TargetPermanent((FilterPermanent)filterSpirit));
        this.addAbility((Ability)new SimpleStaticAbility((Effect)new GainAbilityAllEffect((Ability)ability2, Duration.WhileOnBattlefield, (FilterPermanent)filterNotSpirit, "Non-Spirit creatures have \"When this creature enters the battlefield, you may have it deal 3 damage to target Spirit creature.\"")));
    }

    private ClashOfRealities(ClashOfRealities card) {
        super((CardImpl)card);
    }

    public ClashOfRealities copy() {
        return new ClashOfRealities(this);
    }

    static {
        filterSpirit.add((Predicate)SubType.SPIRIT.getPredicate());
        filterNotSpirit.add(Predicates.not((Predicate)SubType.SPIRIT.getPredicate()));
    }

    private static class ClashOfRealitiesTriggeredAbility
    extends ZoneChangeTriggeredAbility {
        public ClashOfRealitiesTriggeredAbility(Effect effect, String rule) {
            super(Zone.BATTLEFIELD, effect, rule, true);
        }

        private ClashOfRealitiesTriggeredAbility(ClashOfRealitiesTriggeredAbility ability) {
            super((ZoneChangeTriggeredAbility)ability);
        }

        public ClashOfRealitiesTriggeredAbility copy() {
            return new ClashOfRealitiesTriggeredAbility(this);
        }
    }
}

