/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class ClayGolemCost
extends CostImpl {
    private int lastRoll = 0;

    ClayGolemCost() {
        this.text = "roll a d8";
    }

    private ClayGolemCost(ClayGolemCost cost) {
        super((CostImpl)cost);
        this.lastRoll = cost.lastRoll;
    }

    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        return true;
    }

    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        Player player = game.getPlayer(controllerId);
        if (player == null) {
            return this.paid;
        }
        this.lastRoll = player.rollDice(Outcome.Benefit, source, game, 8);
        this.paid = true;
        return this.paid;
    }

    public ClayGolemCost copy() {
        return new ClayGolemCost(this);
    }

    public int getLastRoll() {
        return this.lastRoll;
    }
}

