/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Iterator;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class CleansingEffect
extends OneShotEffect {
    CleansingEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "For each land, destroy that land unless any player pays 1 life";
    }

    private CleansingEffect(CleansingEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Iterator permanents = game.getBattlefield().getActivePermanents(source.getControllerId(), game).iterator();
        while (permanents.hasNext()) {
            boolean paidLife = false;
            Permanent p = (Permanent)permanents.next();
            if (!p.isLand(game)) continue;
            game.informPlayers("Any player may pay 1 life to prevent the destruction of " + p.getLogName() + " controlled by " + game.getPlayer(p.getControllerId()).getLogName() + ".");
            PayLifeCost cost = new PayLifeCost(1);
            for (UUID playerId : game.getState().getPlayerList(source.getControllerId())) {
                Player player = game.getPlayer(playerId);
                if (player == null) continue;
                cost.clearPaid();
                if (!cost.canPay(source, source, player.getId(), game) || !player.chooseUse(this.outcome, "Pay 1 life to prevent this?", source, game) || !cost.pay(source, game, source, player.getId(), false, null)) continue;
                game.informPlayers(player.getLogName() + " pays 1 life to prevent the destruction of " + p.getLogName());
                paidLife = true;
            }
            if (paidLife) continue;
            p.destroy(source, game, false);
        }
        return true;
    }

    public CleansingEffect copy() {
        return new CleansingEffect(this);
    }
}

