/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class ClergyOfTheHolyNimbusReplacementEffect
extends ReplacementEffectImpl {
    ClergyOfTheHolyNimbusReplacementEffect() {
        super(Duration.Custom, Outcome.Regenerate);
        this.staticText = "If {this} would be destroyed, regenerate it";
    }

    private ClergyOfTheHolyNimbusReplacementEffect(ClergyOfTheHolyNimbusReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent ClergyOfTheHolyNimbus2 = game.getPermanent(event.getTargetId());
        if (ClergyOfTheHolyNimbus2 != null && event.getAmount() == 0 && ClergyOfTheHolyNimbus2.regenerate(source, game)) {
            game.informPlayers(source.getSourceObject(game).getName() + " has been regenerated.");
            return true;
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DESTROY_PERMANENT;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getTargetId() != null && event.getTargetId().equals(source.getSourceId());
    }

    public ClergyOfTheHolyNimbusReplacementEffect copy() {
        return new ClergyOfTheHolyNimbusReplacementEffect(this);
    }
}

