/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class ClericClassReturnEffect
extends OneShotEffect {
    ClericClassReturnEffect() {
        super(Outcome.Benefit);
        this.staticText = "return target creature card from your graveyard to the battlefield. You gain life equal to that creature's toughness";
    }

    private ClericClassReturnEffect(ClericClassReturnEffect effect) {
        super((OneShotEffect)effect);
    }

    public ClericClassReturnEffect copy() {
        return new ClericClassReturnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(source.getFirstTarget());
        if (player == null || card == null) {
            return false;
        }
        player.moveCards(card, Zone.BATTLEFIELD, source, game);
        game.processAction();
        Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
        int toughness = permanent != null ? permanent.getToughness().getValue() : card.getToughness().getValue();
        player.gainLife(toughness, game, source);
        return true;
    }
}

