/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class ClockworkBeastEffect
extends OneShotEffect {
    ClockworkBeastEffect() {
        super(Outcome.Benefit);
        this.staticText = "put up to X +1/+0 counters on {this}. This ability can't cause the total number of +1/+0 counters on {this} to be greater than seven";
    }

    private ClockworkBeastEffect(ClockworkBeastEffect effect) {
        super((OneShotEffect)effect);
    }

    public ClockworkBeastEffect copy() {
        return new ClockworkBeastEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (player == null || permanent == null) {
            return false;
        }
        int maxCounters = Integer.min(7 - permanent.getCounters(game).getCount(CounterType.P1P0), (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0));
        if (maxCounters < 1) {
            return false;
        }
        int toAdd = player.getAmount(0, maxCounters, "Choose how many +1/+0 counters to put on " + permanent.getName(), source, game);
        return toAdd > 0 && permanent.addCounters(CounterType.P1P0.createInstance(toAdd), source.getControllerId(), source, game, null, true, 7);
    }
}

