/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheEndOfCombatDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.RemoveCounterSourceEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ClockworkVorracEffect
extends OneShotEffect {
    ClockworkVorracEffect() {
        super(Outcome.UnboostCreature);
        this.staticText = "remove a +1/+1 counter from {this} at end of combat";
    }

    private ClockworkVorracEffect(ClockworkVorracEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent p = game.getPermanent(source.getSourceId());
        if (p != null) {
            AtTheEndOfCombatDelayedTriggeredAbility ability = new AtTheEndOfCombatDelayedTriggeredAbility((Effect)new RemoveCounterSourceEffect(CounterType.P1P1.createInstance()));
            game.addDelayedTriggeredAbility((DelayedTriggeredAbility)ability, source);
        }
        return false;
    }

    public ClockworkVorracEffect copy() {
        return new ClockworkVorracEffect(this);
    }
}

