/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Optional;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.abilities.keyword.WarpAbility;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreatureCard;
import mage.game.Exile;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInExile;
import mage.target.common.TargetControlledCreaturePermanent;
import mage.util.CardUtil;

class CloseEncounterCost
extends CostImpl {
    private static final FilterCard filterCard = new FilterCreatureCard("warped creature card you own in exile");

    public CloseEncounterCost() {
        this.text = "choose a creature you control or a warped creature card you own in exile";
    }

    private CloseEncounterCost(CloseEncounterCost cost) {
        super((CostImpl)cost);
    }

    public CloseEncounterCost copy() {
        return new CloseEncounterCost(this);
    }

    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        return Optional.ofNullable(CardUtil.getExileZoneId((String)WarpAbility.makeWarpString((UUID)controllerId), (Game)game)).map(arg_0 -> ((Exile)game.getExile()).getExileZone(arg_0)).filter(exileZone -> !exileZone.getCards(filterCard, game).isEmpty()).isPresent() || game.getBattlefield().contains((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, controllerId, source, game, 1);
    }

    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        boolean usePermanent;
        Player player = game.getPlayer(controllerId);
        if (player == null) {
            this.paid = false;
            return this.paid;
        }
        boolean hasPermanent = game.getBattlefield().contains((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, controllerId, source, game, 1);
        boolean hasWarp = Optional.ofNullable(CardUtil.getExileZoneId((String)WarpAbility.makeWarpString((UUID)controllerId), (Game)game)).map(arg_0 -> ((Exile)game.getExile()).getExileZone(arg_0)).filter(exileZone -> !exileZone.getCards(filterCard, game).isEmpty()).isPresent();
        if (hasPermanent && hasWarp) {
            usePermanent = player.chooseUse(Outcome.Neutral, "Choose a creature you control or a warped creature you own in exile?", null, "Choose controlled", "Choose from exile", source, game);
        } else if (hasPermanent) {
            usePermanent = true;
        } else if (hasWarp) {
            usePermanent = false;
        } else {
            this.paid = false;
            return this.paid;
        }
        if (usePermanent) {
            TargetControlledCreaturePermanent target = new TargetControlledCreaturePermanent();
            target.withNotTarget(true);
            player.choose(Outcome.Neutral, (Target)target, source, game);
            Permanent permanent = game.getPermanent(target.getFirstTarget());
            if (permanent == null) {
                this.paid = false;
                return this.paid;
            }
            game.informPlayers(player.getLogName() + " chooses " + permanent.getLogName() + " on the battlefield");
            source.getEffects().setValue("closeEncounterCost", (Object)permanent);
            this.paid = true;
            return true;
        }
        TargetCardInExile target = new TargetCardInExile(filterCard, CardUtil.getExileZoneId((String)WarpAbility.makeWarpString((UUID)controllerId), (Game)game));
        player.choose(Outcome.Neutral, (Target)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card == null) {
            this.paid = false;
            return this.paid;
        }
        game.informPlayers(player.getLogName() + " chooses " + card.getLogName() + " from exile");
        source.getEffects().setValue("closeEncounterCost", (Object)card);
        this.paid = true;
        return this.paid;
    }
}

