/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.GetXValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.token.ClownRobotToken;
import mage.players.Player;

class ClownCarEffect
extends OneShotEffect {
    ClownCarEffect() {
        super(Outcome.Benefit);
        this.staticText = "roll X six-sided dice. For each odd result, create a 1/1 white Clown Robot artifact creature token. For each even result, put a +1/+1 on {this}";
    }

    private ClownCarEffect(ClownCarEffect effect) {
        super((OneShotEffect)effect);
    }

    public ClownCarEffect copy() {
        return new ClownCarEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int evens;
        Player player = game.getPlayer(source.getControllerId());
        int xValue = GetXValue.instance.calculate(game, source, (Effect)this);
        if (player == null || xValue < 1) {
            return false;
        }
        Map rollMap = player.rollDice(this.outcome, source, game, 6, xValue, 0).stream().map(x -> x % 2).collect(Collectors.toMap(Function.identity(), x -> 1, Integer::sum));
        int odds = rollMap.getOrDefault(1, 0);
        if (odds > 0) {
            new ClownRobotToken().putOntoBattlefield(odds, game, source);
        }
        if ((evens = rollMap.getOrDefault(0, 0).intValue()) > 0) {
            Optional.ofNullable(source.getSourcePermanentIfItStillExists(game)).ifPresent(permanent -> permanent.addCounters(CounterType.P1P1.createInstance(evens), source, game));
        }
        return true;
    }
}

