/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class CoercedConfessionMillEffect
extends OneShotEffect {
    CoercedConfessionMillEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Target player mills four cards. You draw a card for each creature card put into their graveyard this way";
    }

    private CoercedConfessionMillEffect(CoercedConfessionMillEffect effect) {
        super((OneShotEffect)effect);
    }

    public CoercedConfessionMillEffect copy() {
        return new CoercedConfessionMillEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player == null) {
            return false;
        }
        int creaturesMilled = player.millCards(4, source, game).getCards(game).stream().filter(Objects::nonNull).filter(card -> game.getState().getZone(card.getId()) == Zone.GRAVEYARD).filter(card1 -> card1.isCreature(game)).mapToInt(x -> 1).sum();
        if (creaturesMilled < 1) {
            return true;
        }
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return true;
        }
        game.processAction();
        controller.drawCards(creaturesMilled, source, game);
        return true;
    }
}

