/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetCard;
import mage.target.common.TargetOpponent;

class CoinOfFateEffect
extends OneShotEffect {
    public CoinOfFateEffect() {
        super(Outcome.Benefit);
        this.staticText = "An opponent chooses one of the exiled cards. You put that card on the bottom of your library and return the other to the battlefield tapped";
    }

    private CoinOfFateEffect(CoinOfFateEffect effect) {
        super((OneShotEffect)effect);
    }

    public CoinOfFateEffect copy() {
        return new CoinOfFateEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player opponent;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl((Collection)this.getTargetPointer().getTargets(game, source));
        if (cards.isEmpty()) {
            return false;
        }
        Set opponents = game.getOpponents(controller.getId());
        if (opponents.size() == 1) {
            opponent = game.getPlayer((UUID)opponents.iterator().next());
        } else {
            TargetOpponent targetOpponent = new TargetOpponent(true);
            controller.chooseTarget(Outcome.Detriment, (Target)targetOpponent, source, game);
            opponent = game.getPlayer(targetOpponent.getFirstTarget());
        }
        if (opponent == null) {
            return false;
        }
        TargetCard targetCard = new TargetCard(Zone.EXILED, (FilterCard)StaticFilters.FILTER_CARD_CREATURE);
        targetCard.withChooseHint("card to put on the bottom of opponent's library, the other is put onto the battlefield tapped");
        opponent.chooseTarget(Outcome.Benefit, (Cards)cards, targetCard, source, game);
        Card cardToLibrary = game.getCard(targetCard.getFirstTarget());
        if (cardToLibrary != null) {
            controller.moveCardToLibraryWithInfo(cardToLibrary, source, game, Zone.EXILED, false, true);
            cards.remove(cardToLibrary);
        }
        if (!cards.isEmpty()) {
            controller.moveCards(game.getCard((UUID)cards.iterator().next()), Zone.BATTLEFIELD, source, game, true, false, true, null);
        }
        return true;
    }
}

