/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Mode;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.target.Target;
import mage.target.common.TargetArtifactPermanent;
import mage.target.common.TargetCreaturePermanent;

public final class CollisionCourse
extends CardImpl {
    private static final FilterPermanent filter = new FilterControlledPermanent("permanents you control that are creatures and/or Vehicles");
    private static final DynamicValue xValue;
    private static final Hint hint;

    public CollisionCourse(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.SORCERY}, "{1}{W}");
        this.getSpellAbility().addEffect((Effect)new DamageTargetEffect(xValue).setText("{this} deals X damage to target creature, where X is the number of permanents you control that are creatures and/or Vehicles"));
        this.getSpellAbility().addTarget((Target)new TargetCreaturePermanent());
        this.getSpellAbility().addHint(hint);
        this.getSpellAbility().addMode(new Mode((Effect)new DestroyTargetEffect()).addTarget((Target)new TargetArtifactPermanent()));
    }

    private CollisionCourse(CollisionCourse card) {
        super((CardImpl)card);
    }

    public CollisionCourse copy() {
        return new CollisionCourse(this);
    }

    static {
        filter.add(Predicates.or((Predicate)CardType.CREATURE.getPredicate(), (Predicate)SubType.VEHICLE.getPredicate()));
        xValue = new PermanentsOnBattlefieldCount(filter, null);
        hint = new ValueHint("Creatures and Vehicles you control", xValue);
    }
}

