/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersAllEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class ColonelAutumnTriggeredAbility
extends TriggeredAbilityImpl {
    ColonelAutumnTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new AddCountersAllEffect(CounterType.P1P1.createInstance(), (FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE_CONTROLLED));
        this.setTriggerPhrase("Whenever a creature you control exploits a creature, ");
    }

    private ColonelAutumnTriggeredAbility(ColonelAutumnTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.EXPLOITED_CREATURE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent exploiter = game.getPermanentOrLKIBattlefield(event.getSourceId());
        Permanent exploited = game.getPermanentOrLKIBattlefield(event.getTargetId());
        return exploiter != null && exploited != null && exploiter.isCreature(game) && exploited.isCreature(game) && exploiter.isControlledBy(this.getControllerId());
    }

    public ColonelAutumnTriggeredAbility copy() {
        return new ColonelAutumnTriggeredAbility(this);
    }
}

